# ============================================================================
# Exercise 3: Write Clean Data - TEMPLATE
# Module: Data Importing, Tidying and Writing
# ============================================================================

# INSTRUCTIONS:
# Complete the code below by filling in the blanks (___) and following
# the step-by-step guidance. Run each section to check your work!

# NOTE: This exercise assumes you have completed Exercises 1 and 2 and have
# the following cleaned datasets: dt_firms, panel_vat, and panel_cit
# If you don't have them loaded, re-run Exercises 1 and 2 first!

# ============================================================================
# PART 1: Load Required Packages
# ============================================================================

# Step 1: Load the data.table, arrow, and here packages
# TODO: Load all three packages
library(___)
library(___)
library(___)


# ============================================================================
# PART 2: Save Firm Characteristics as CSV
# ============================================================================

# Step 2: Save dt_firms as CSV using fwrite()
# HINT: fwrite() is fast and efficient for writing CSV files
# TODO: Use fwrite() to save to "../../data/intermediate/firms_clean.csv"
fwrite(___, here("___", "___", "firms_clean.csv"))


# ============================================================================
# PART 3: Save VAT Declarations as RDS
# ============================================================================

# Step 3: Save panel_vat as RDS using saveRDS()
# HINT: RDS format preserves R data types and is efficient for R-to-R workflows
# TODO: Use saveRDS() to save to "../../data/intermediate/vat_clean.rds"
saveRDS(___, here("___", "___", "vat_clean.rds"))


# ============================================================================
# PART 4: Save CIT Declarations as Parquet
# ============================================================================

# Step 4: Save panel_cit as Parquet using write_parquet()
# HINT: Parquet is excellent for large datasets with columnar storage
# TODO: Use write_parquet() to save to "../../data/intermediate/cit_clean.parquet"
write_parquet(___, here("___", "___", "cit_clean.parquet"))


# ============================================================================
# PART 5: Verify Your Files Were Created
# ============================================================================

# Step 5: Check that your files exist in the intermediate folder
# TODO: Use list.files() to see all files in "../../data/intermediate/"
list.files(here("___", "___"))


# ============================================================================
# BONUS QUESTION (Think and Discuss)
# ============================================================================

# Why did we choose different formats for each dataset?
# Think about:
# - dt_firms (CSV): What are the advantages of CSV format?
# - panel_vat (RDS): When is RDS format useful?
# - panel_cit (Parquet): What makes Parquet good for large datasets?

# Possible answers:
# CSV: Human-readable, widely compatible, good for reference data
# RDS: Preserves R data types, faster loading in R, good for intermediate work
# Parquet: Efficient columnar storage, fast queries, excellent for large datasets


# ============================================================================
# CONGRATULATIONS!
# You've completed Exercise 3. Make sure all your code runs without errors.
# Compare your results with the solution script when you're done.
# ============================================================================
