# Exercise 05: Create a Faceted Visualization
# Module 5: Data Visualization with ggplot2

# Load required libraries
library(ggplot2)
library(data.table)
library(here)

# Load data
vat_gap_analysis <- fread(here("r_training_datax", "data", "Final", "vat_gap_analysis.csv"))

# Task: Create a faceted histogram of VAT gaps by firm size
# 
# Requirements:
# 1. Create histogram of vat_gap with binwidth = 5000
# 2. Facet by firm_size using facet_wrap()
# 3. Use fill color "#3B9AB2" with white borders
# 4. Set scales = "free_y" to allow different y-axis ranges
# 5. Add appropriate labels

# Step 1: Start with ggplot() and map vat_gap to x aesthetic


# Step 2: Add geom_histogram()
# Use binwidth = 5000, fill = "#3B9AB2", color = "white"


# Step 3: Add facet_wrap() to create separate panels by firm_size
# Use scales = "free_y" to allow different y-axis ranges for each panel


# Step 4: Add labels
#         - title: "Distribution of VAT Gaps by Firm Size"
#         - x: "VAT Gap (USD)"
#         - y: "Number of Firms"


# Step 5: Add theme_minimal()


# Your complete code here:

