# Final Exercise: Create a Professional Report Figure
# Module 5: Data Visualization with ggplot2

# Load required libraries
library(ggplot2)
library(data.table)
library(here)

# Load data
vat_gap_analysis <- fread(here("r_training_datax", "data", "Final", "vat_gap_analysis.csv"))

# Task: Create a polished, three-panel figure for a tax administration report
# 
# Requirements:
# Create three separate plots and combine them:
#   Panel A: Boxplot of vat_gap by firm_size
#   Panel B: Bar chart of total actual_vat by industry (sorted)
#   Panel C: Scatterplot of expected_vat vs actual_vat with trend line
#
# All plots must include:
#   - Proper titles and axis labels
#   - Professional theme (theme_minimal())
#   - Appropriate colors
#   - Data source caption
#
# Save as high-resolution PNG (300 dpi)

# ========================================
# Panel A: Boxplot
# ========================================

# Step 1: Create boxplot of vat_gap by firm_size


# Step 2: Use fill color "#3B9AB2"


# Step 3: Add labels
#         - title: "Panel A: VAT Gap Distribution by Firm Size"
#         - x: "Firm Size"
#         - y: "VAT Gap (USD)"


# Step 4: Add theme_minimal()


# Step 5: Store in object named plot_a


# Your code for Panel A:


# ========================================
# Panel B: Bar Chart
# ========================================

# Step 1: Aggregate data - calculate total actual_vat by industry


# Step 2: Create bar chart with sorted bars
# Use reorder(industry, total_vat) to sort


# Step 3: Use geom_col() with fill color "#3B9AB2"


# Step 4: Add coord_flip() for horizontal bars


# Step 5: Add labels
#         - title: "Panel B: Total VAT Collection by Industry"
#         - x: NULL
#         - y: "Total VAT Collected (USD)"


# Step 6: Add theme_minimal()


# Step 7: Store in object named plot_b


# Your code for Panel B:


# ========================================
# Panel C: Scatterplot with Trend Line
# ========================================

# Step 1: Create scatterplot of expected_vat vs actual_vat


# Step 2: Add geom_point() with alpha = 0.5


# Step 3: Add geom_smooth() with method = "lm"
# Use color = "red" and se = FALSE


# Step 4: Add reference line (geom_abline) where expected = actual
# Use slope = 1, intercept = 0, color = "blue", linetype = "dashed"


# Step 5: Add labels
#         - title: "Panel C: Actual vs. Expected VAT"
#         - x: "Expected VAT (USD)"
#         - y: "Actual VAT (USD)"
#         - caption: "Source: Tax Administration Database | Dashed line = perfect compliance"


# Step 6: Add theme_minimal()


# Step 7: Store in object named plot_c


# Your code for Panel C:


# ========================================
# Combine and Save
# ========================================

# If you want to combine plots (optional, requires patchwork package):
# library(patchwork)
# combined_plot <- plot_a / plot_b / plot_c

# Save individual plots or combined plot as PNG with high resolution
# Use ggsave() with width = 10, height = 8, dpi = 300


# Your saving code:

