# Exercise 02 Solution: Create a Bar Chart
# Module 5: Data Visualization with ggplot2

library(ggplot2)
library(data.table)
library(here)

vat_gap_analysis <- fread(here("r_training_datax", "data", "Final", "vat_gap_analysis.csv"))

firm_counts <- vat_gap_analysis[, .(count = .N), by = firm_size]

ggplot(firm_counts, aes(x = reorder(firm_size, count), y = count)) +
  geom_col(fill = "#3B9AB2") +
  coord_flip() +
  labs(
    title = "Number of Firms by Size Category",
    x = NULL,
    y = "Number of Firms"
  ) +
  theme_minimal()
