# Final Exercise Solution: Create a Professional Report Figure
# Module 5: Data Visualization with ggplot2

library(ggplot2)
library(data.table)
library(here)

vat_gap_analysis <- fread(here("r_training_datax", "data", "Final", "vat_gap_analysis.csv"))

plot_a <- ggplot(vat_gap_analysis, aes(x = firm_size, y = vat_gap)) +
  geom_boxplot(fill = "#3B9AB2") +
  labs(
    title = "Panel A: VAT Gap Distribution by Firm Size",
    x = "Firm Size",
    y = "VAT Gap (USD)"
  ) +
  theme_minimal()

industry_totals <- vat_gap_analysis[, .(total_vat = sum(actual_vat)), by = industry]

plot_b <- ggplot(industry_totals, aes(x = reorder(industry, total_vat), y = total_vat)) +
  geom_col(fill = "#3B9AB2") +
  coord_flip() +
  labs(
    title = "Panel B: Total VAT Collection by Industry",
    x = NULL,
    y = "Total VAT Collected (USD)"
  ) +
  theme_minimal()

plot_c <- ggplot(vat_gap_analysis, aes(x = expected_vat, y = actual_vat)) +
  geom_point(alpha = 0.5) +
  geom_smooth(method = "lm", color = "red", se = FALSE) +
  geom_abline(slope = 1, intercept = 0, color = "blue", linetype = "dashed") +
  labs(
    title = "Panel C: Actual vs. Expected VAT",
    x = "Expected VAT (USD)",
    y = "Actual VAT (USD)",
    caption = "Source: Tax Administration Database | Dashed line = perfect compliance"
  ) +
  theme_minimal()

ggsave(
  filename = here("r_training_datax", "outputs", "panel_a_vat_gaps.png"),
  plot = plot_a,
  width = 10,
  height = 6,
  dpi = 300
)

ggsave(
  filename = here("r_training_datax", "outputs", "panel_b_industry_totals.png"),
  plot = plot_b,
  width = 10,
  height = 6,
  dpi = 300
)

ggsave(
  filename = here("r_training_datax", "outputs", "panel_c_compliance.png"),
  plot = plot_c,
  width = 10,
  height = 6,
  dpi = 300
)
